package gov.va.med.mhv.usermgmt.service.handler;

import java.io.File;
import java.io.PrintStream;
import java.util.Set;

import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMviLoggingHandler  implements SOAPHandler<SOAPMessageContext>{

	private static final Log LOG = LogFactory.getLog(SOAPMviLoggingHandler.class);
	// change this to redirect output if desired
	private static PrintStream out = System.out;
	//private static PrintStream out = new File("mvi-logging.log");

	public Set getHeaders() {
		return null;
	}

	public boolean handleMessage(SOAPMessageContext smc) {
		logToSystemOut(smc);
		return true;
	}

	public boolean handleFault(SOAPMessageContext smc) {
		logToSystemOut(smc);
		return true;
	}

	// nothing to clean up
	public void close(MessageContext messageContext) {
	}

	/*
	 * Check the MESSAGE_OUTBOUND_PROPERTY in the context
	 * to see if this is an outgoing or incoming message.
	 * Write a brief message to the print stream and
	 * output the message. The writeTo() method can throw
	 * SOAPException or IOException
	 */
	private void logToSystemOut(SOAPMessageContext smc) {
		Boolean outboundProperty = (Boolean)
		smc.get (MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		if (outboundProperty.booleanValue()) {
			if(LOG.isDebugEnabled())
				LOG.debug("\nFrom LoggingHandler Outbound message:");
		} else {
			if(LOG.isDebugEnabled())
				LOG.debug("\nFrom LoggingHandler Inbound message:");
		}

		SOAPMessage message = smc.getMessage();
		try {
			message.writeTo(out);
			if(LOG.isDebugEnabled())
				LOG.debug(""); // just to add a newline
		} catch (Exception e) {
			LOG.error("Exception in handler: " + e);
		}

	}
}
